<?php

namespace App\Providers;

use Illuminate\Filesystem\Filesystem;
use Illuminate\Routing\Router;
use Illuminate\Support\ServiceProvider;
use Symfony\Component\Finder\SplFileInfo;

class NioAddonsServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        try {
            if (!empty($addons = available_modules('addon'))) {
                foreach ($addons as $addon) {
                    if (file_exists($provider = base_path(implode(DIRECTORY_SEPARATOR, ['nioaddons',$addon, 'Provider', 'RouteServiceProvider.php'])))) {
                        $this->app->register("\NioAddons\\$addon\Provider\RouteServiceProvider");
                    }

                    if (file_exists($filtering = base_path(implode(DIRECTORY_SEPARATOR, ['nioaddons', $addon, 'RequestFilters'])))) {
                        $fileSystem = new Filesystem();
                        collect($fileSystem->files($filtering))->each(function (SplFileInfo $item) use ($addon) {
                            $alias = strtolower($addon . '-' . $item->getBasename('Filter.php'));
                            $file = $item->getBasename('.php');
                            $this->app->make(Router::class)->aliasMiddleware($alias, "NioAddons\\{$addon}\\RequestFilters\\{$file}");
                        });
                    }

                    if (file_exists($views = base_path(implode(DIRECTORY_SEPARATOR, ['nioaddons', $addon, 'Views'])))) {
                        $this->loadViewsFrom($views, $addon);
                    }

                    if (file_exists($config = base_path(implode(DIRECTORY_SEPARATOR, ['nioaddons', $addon, 'Config', 'addon.php'])))) {
                        $this->mergeConfigFrom($config, 'modules');
                    }

                    if (file_exists($migrations = base_path(implode(DIRECTORY_SEPARATOR, ['nioaddons', $addon, 'Database', 'migrations'])))) {
                        $this->loadMigrationsFrom($migrations);
                    }

                    if (class_exists($addonLoader = "\\NioAddons\\{$addon}\\{$addon}")) {
                        $this->app->bind(strtolower($addon), function () use ($addonLoader) {
                            return new $addonLoader();
                        });
                    }

                    if (file_exists($eventProvider = base_path(implode(DIRECTORY_SEPARATOR, ['nioaddons',$addon, 'Provider', 'EventServiceProvider.php'])))) {
                        $this->app->register("\NioAddons\\$addon\Provider\EventServiceProvider");
                    }

                    if (file_exists($scheduleProvider = base_path(implode(DIRECTORY_SEPARATOR, ['nioaddons',$addon, 'Provider', 'ScheduleServiceProvider.php'])))) {
                        $this->app->register("\NioAddons\\$addon\Provider\ScheduleServiceProvider");
                    }

                    if (file_exists($apiTokenProvider = base_path(implode(DIRECTORY_SEPARATOR, ['nioaddons',$addon, 'Provider', 'InvestormTokenServiceProvider.php'])))) {
                        $this->app->register("\NioAddons\\$addon\Provider\InvestormTokenServiceProvider");
                    }
                }
            }
        } catch (\Exception $e) {
            if (env('APP_DEBUG', false)) {
                save_error_log($e, 'addon-service');
            }
        }
    }
}
